@extends('admin.layout.master')

@section('body')





    <h4 class="mb-4"><i class="fa fa-users"></i> User Statistics</h4>
    <div class="row mb-4">
        <div class="col-md">
            <a href="{{route('users')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-primary text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-users"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Total Users</p>
                        <h3 class="font-weight-bold mb-0">{{$totalUsers}}</h3>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md">
            <a href="{{route('users')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-success text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-users"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Email Verified</p>
                        <h3 class="font-weight-bold mb-0">{{$email_verify}}</h3>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md">
            <a href="{{route('users')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-info text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-users"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Phone verified</p>
                        <h3 class="font-weight-bold mb-0">{{$phone_verify}}</h3>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md">
            <a href="{{route('user.ban')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-danger text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-users"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Ban Users</p>
                        <h3 class="font-weight-bold mb-0">{{$banUsers}}</h3>
                    </div>
                </div>
            </a>
        </div>

    </div>



    <h4 class="mb-4"><i class="fa fa-th"></i> Money Exchange Statistics</h4>
    <div class="row mb-4">


        <div class="col-md">
            <a href="{{route('exchange.requests')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-warning text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-spinner"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Pending Order </p>
                        <h3 class="font-weight-bold mb-0">{{$exchangePending}}</h3>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md">
            <a href="{{route('exchange.approved')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-success text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-check"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Confirm Order </p>
                        <h3 class="font-weight-bold mb-0">{{$exchangeSucc}}</h3>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md">
            <a href="{{route('exchange.cancel')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-danger text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-times"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Order Cancel </p>
                        <h3 class="font-weight-bold mb-0">{{$exchangeCan}}</h3>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md">
            <a href="{{route('exchange.refund')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-danger text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-hand-holding-usd"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Refund Order </p>
                        <h3 class="font-weight-bold mb-0">{{$exchangeRefund}}</h3>
                    </div>
                </div>
            </a>
        </div>

    </div>





    <h4 class="mb-4"><i class="fa fa-th"></i> Withdraw Statistics</h4>
    <div class="row mb-4">


        <div class="col-md">
            <a href="{{route('withdraw.requests')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-warning text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-spinner"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Pending Withdraw </p>
                        <h3 class="font-weight-bold mb-0">{{$withdrawReq}}</h3>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md">
            <a href="{{route('withdraw.approved')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-success text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-check"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Success Withdraw </p>
                        <h3 class="font-weight-bold mb-0">{{$withdrawSuc}}</h3>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md">
            <a href="{{route('withdraw.refunded')}}" class="textDecoration">
                <div class="d-flex border">
                    <div class="bg-danger text-light p-4">
                        <div class="d-flex align-items-center h-100">
                            <i class="fa fa-3x fa-fw fa-times"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1 bg-white p-4">
                        <p class="text-uppercase text-secondary mb-0">Refund Withdraw </p>
                        <h3 class="font-weight-bold mb-0">{{$withdrawRefund}}</h3>
                    </div>
                </div>
            </a>
        </div>

    </div>




    <div class="row mb-4">

        <div class="col-md-6">
            <h4 class="mb-4">  <i class="fas fa-credit-card"></i> Deposit Statistics </h4>
            <div class="row mb-4">
                <div class="col-md">
                    <a href="{{route('gateway')}}" class="textDecoration">
                        <div class="d-flex border">
                            <div class="bg-success text-light p-4">
                                <div class="d-flex align-items-center h-100">
                                    <i class="fa-3x  fas fa-credit-card"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 bg-white p-4">
                                <p class="text-uppercase text-secondary mb-0">Deposit Method</p>
                                <h3 class="font-weight-bold mb-0">{{$gateway}}</h3>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-md">
                    <a href="{{route('deposits')}}" class="textDecoration">
                        <div class="d-flex border">
                            <div class="bg-info text-light p-4">
                                <div class="d-flex align-items-center h-100">
                                    <i class="fas fa-dollar-sign fa-3x"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 bg-white p-4">
                                <p class="text-uppercase text-secondary mb-0">Number Of Deposit</p>
                                <h3 class="font-weight-bold mb-0">{{$deposit}}</h3>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <h4 class="mb-4"><i class="fa fa-info-circle"></i> Other Info</h4>
            <div class="row mb-4">
                <div class="col-md">
                    <a href="{{route('admin.blog')}}" class="textDecoration">
                        <div class="d-flex border">
                            <div class="bg-success text-light p-4">
                                <div class="d-flex align-items-center h-100">
                                    <i class="fa fa-3x fa-fw fa-newspaper"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 bg-white p-4">
                                <p class="text-uppercase text-secondary mb-0">Total Blogs</p>
                                <h3 class="font-weight-bold mb-0">{{$blog}}</h3>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-md">
                    <a href="{{route('manage.subscribers')}}" class="textDecoration">
                        <div class="d-flex border">
                            <div class="bg-primary text-light p-4">
                                <div class="d-flex align-items-center h-100">
                                    <i class="fa fa-3x fa-fw fa-thumbs-up"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 bg-white p-4">
                                <p class="text-uppercase text-secondary mb-0">Total Subscriber</p>
                                <h3 class="font-weight-bold mb-0">{{$subscriber}}</h3>
                            </div>
                        </div>
                    </a>
                </div>


            </div>
        </div>

    </div>







@endsection

@section('script')


@stop

